//Listing 13.15. Przykad hierarchii dziedziczenia dla klas Account
#include <iostream>
using namespace std;

class Account { // klasa bazowa
protected:
  double balance;
public:
  Account(double initBalance = 0)
  { balance = initBalance; }
  double getBal() // odziedziczone bez zmian
  { return balance; }
  void withdraw(double amount) // zdefiniowana ponownie w klasie pochodnej
  { if (balance > amount)
      balance -= amount; }
  void deposit(double amount) // odziedziczone bez zmian
  { balance += amount; }
} ;

class CheckingAccount : public Account { // klasa pochodna
  double fee;
public:
  CheckingAccount(double initBalance)
  { balance = initBalance; fee = 0.2; }
  void withdraw(double amount)
  { if (balance > amount)
      balance = balance - amount - fee; }
  void deposit(double amount) // ukrywa metod z klasy bazowej
  { Account::deposit(amount); } // wywoanie funkcji z klasy bazowej
  void deposit(double amount, double fee) // ukrywa metod z klasy bazowej
  { balance = balance + amount - fee - CheckingAccount::fee; }
} ;

int main()
{
  CheckingAccount a1(1000); // obiekt klasy pochodnej
  a1.withdraw(100); // metoda klasy pochodnej
  a1.deposit(200); // istniejcy kod klienta
  a1.deposit(200,5); // nowy kod klienta
  cout << " Kocowe stany kont\n";
  cout << " sprawdzanie obiektu konta: " << a1.getBal() <<endl;
  return 0;
}
